/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.widget;

import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.drawable.Drawable;
import icyllis.modernui.view.MeasureSpec;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import icyllis.modernui.widget.Orientation;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LinearLayout
extends ViewGroup {
    public static final int SHOW_DIVIDER_NONE = 0;
    public static final int SHOW_DIVIDER_BEGINNING = 1;
    public static final int SHOW_DIVIDER_MIDDLE = 2;
    public static final int SHOW_DIVIDER_END = 4;
    private Orientation orientation;
    private int gravity = 51;
    private float weightSum;
    private int totalLength;
    private int[] maxAscent;
    private int[] maxDescent;
    private static final int INDEX_CENTER_VERTICAL = 0;
    private static final int INDEX_TOP = 1;
    private static final int INDEX_BOTTOM = 2;
    private static final int INDEX_FILL = 3;
    private Drawable divider;
    private int showDividers;
    private int dividerWidth;
    private int dividerHeight;
    private int dividerPadding;

    public final boolean isShowingDividers() {
        return this.showDividers != 0 && this.divider != null;
    }

    public void setShowDividers(int showDividers) {
        if (this.showDividers == showDividers) {
            return;
        }
        this.showDividers = showDividers;
        this.requestLayout();
    }

    public int getShowDividers() {
        return this.showDividers;
    }

    public void setDivider(@Nullable Drawable divider) {
        if (this.divider == divider) {
            return;
        }
        this.divider = divider;
        if (divider != null) {
            this.dividerWidth = divider.getIntrinsicWidth();
            this.dividerHeight = divider.getIntrinsicHeight();
        } else {
            this.dividerWidth = 0;
            this.dividerHeight = 0;
        }
        this.requestLayout();
    }

    @Nullable
    public Drawable getDivider() {
        return this.divider;
    }

    public int getDividerWidth() {
        return this.dividerWidth;
    }

    public int getDividerHeight() {
        return this.dividerHeight;
    }

    public void setDividerPadding(int padding) {
        if (padding == this.dividerPadding) {
            return;
        }
        this.dividerPadding = padding;
        if (this.isShowingDividers()) {
            this.requestLayout();
        }
    }

    public int getDividerPadding() {
        return this.dividerPadding;
    }

    public void setWeightSum(float weightSum) {
        this.weightSum = Math.max(0.0f, weightSum);
    }

    public float getWeightSum() {
        return this.weightSum;
    }

    @Override
    protected void onDraw(@Nonnull Canvas canvas) {
        if (this.divider != null) {
            if (this.orientation == Orientation.VERTICAL) {
                this.drawDividersVertical(canvas);
            } else {
                this.drawDividersHorizontal(canvas);
            }
        }
    }

    private void drawDividersVertical(@Nonnull Canvas canvas) {
        boolean began = false;
        View lastDraw = null;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 2) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int top = child.getTop() - lp.topMargin - this.dividerHeight;
            if (!began) {
                if ((this.showDividers & 1) != 0) {
                    this.drawHorizontalDivider(canvas, top);
                }
                began = true;
            } else if ((this.showDividers & 2) != 0) {
                this.drawHorizontalDivider(canvas, top);
            }
            lastDraw = child;
        }
        if ((this.showDividers & 4) != 0) {
            int bottom;
            if (lastDraw != null) {
                LayoutParams lp = (LayoutParams)lastDraw.getLayoutParams();
                bottom = lastDraw.getBottom() + lp.bottomMargin;
            } else {
                bottom = this.getBottom() - this.dividerHeight;
            }
            this.drawHorizontalDivider(canvas, bottom);
        }
    }

    private void drawHorizontalDivider(@Nonnull Canvas canvas, int top) {
        this.divider.setBounds(this.getLeft() + this.dividerPadding, top, this.getRight() - this.dividerPadding, top + this.dividerHeight);
        this.divider.draw(canvas);
    }

    private void drawDividersHorizontal(@Nonnull Canvas canvas) {
        boolean began = false;
        View lastDraw = null;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 2) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int left = child.getLeft() - lp.leftMargin - this.dividerWidth;
            if (!began) {
                if ((this.showDividers & 1) != 0) {
                    this.drawVerticalDivider(canvas, left);
                }
                began = true;
            } else if ((this.showDividers & 2) != 0) {
                this.drawVerticalDivider(canvas, left);
            }
            lastDraw = child;
        }
        if ((this.showDividers & 4) != 0) {
            int right;
            if (lastDraw != null) {
                LayoutParams lp = (LayoutParams)lastDraw.getLayoutParams();
                right = lastDraw.getRight() + lp.rightMargin;
            } else {
                right = this.getRight() - this.dividerWidth;
            }
            this.drawVerticalDivider(canvas, right);
        }
    }

    private void drawVerticalDivider(@Nonnull Canvas canvas, int left) {
        this.divider.setBounds(left, this.getTop() + this.dividerPadding, left + this.dividerWidth, this.getBottom() - this.dividerPadding);
        this.divider.draw(canvas);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.orientation == Orientation.VERTICAL) {
            this.measureVertical(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void measureVertical(int widthMeasureSpec, int heightMeasureSpec) {
        int i;
        this.totalLength = 0;
        int maxWidth = 0;
        int alternativeMaxWidth = 0;
        int weightedMaxWidth = 0;
        boolean allFillParent = true;
        float totalWeight = 0.0f;
        boolean began = false;
        int count = this.getChildCount();
        MeasureSpec.Mode widthMode = MeasureSpec.getMode(widthMeasureSpec);
        MeasureSpec.Mode heightMode = MeasureSpec.getMode(heightMeasureSpec);
        boolean matchWidth = false;
        boolean skippedMeasure = false;
        int consumedExcessSpace = 0;
        int nonSkippedChildCount = 0;
        for (int i2 = 0; i2 < count; ++i2) {
            boolean useExcessSpace;
            View child = this.getChildAt(i2);
            if (child.getVisibility() == 2) continue;
            ++nonSkippedChildCount;
            if (!began) {
                if ((this.showDividers & 1) != 0) {
                    this.totalLength += this.dividerHeight;
                }
                began = true;
            } else if ((this.showDividers & 2) != 0) {
                this.totalLength += this.dividerHeight;
            }
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            totalWeight += lp.weight;
            boolean bl = useExcessSpace = lp.height == 0 && lp.weight > 0.0f;
            if (heightMode.isExactly() && useExcessSpace) {
                this.totalLength = Math.max(this.totalLength, this.totalLength + lp.topMargin + lp.bottomMargin);
                skippedMeasure = true;
            } else {
                if (useExcessSpace) {
                    lp.height = -2;
                }
                int usedHeight = totalWeight == 0.0f ? this.totalLength : 0;
                this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, usedHeight);
                int childHeight = child.getMeasuredHeight();
                if (useExcessSpace) {
                    lp.height = 0;
                    consumedExcessSpace += childHeight;
                }
                this.totalLength = Math.max(this.totalLength, this.totalLength + childHeight + lp.topMargin + lp.bottomMargin);
            }
            boolean matchWidthLocally = false;
            if (widthMode.isVariable() && lp.width == -1) {
                matchWidth = true;
                matchWidthLocally = true;
            }
            int margin = lp.leftMargin + lp.rightMargin;
            int measuredWidth = child.getMeasuredWidth() + margin;
            maxWidth = Math.max(maxWidth, measuredWidth);
            boolean bl2 = allFillParent = allFillParent && lp.width == -1;
            if (lp.weight > 0.0f) {
                weightedMaxWidth = Math.max(weightedMaxWidth, matchWidthLocally ? margin : measuredWidth);
                continue;
            }
            alternativeMaxWidth = Math.max(alternativeMaxWidth, matchWidthLocally ? margin : measuredWidth);
        }
        if (nonSkippedChildCount > 0 && (this.showDividers & 4) != 0) {
            this.totalLength += this.dividerHeight;
        }
        int heightSize = this.totalLength;
        heightSize = Math.max(heightSize, this.getMinHeight());
        heightSize = LinearLayout.resolveSize(heightSize, heightMeasureSpec);
        int remainingExcess = heightSize - this.totalLength + consumedExcessSpace;
        if (skippedMeasure || totalWeight > 0.0f) {
            float remainingWeightSum = this.weightSum > 0.0f ? this.weightSum : totalWeight;
            this.totalLength = 0;
            for (i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (child.getVisibility() == 2) continue;
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                float childWeight = lp.weight;
                if (childWeight > 0.0f) {
                    int share = (int)(childWeight * (float)remainingExcess / remainingWeightSum);
                    remainingExcess -= share;
                    remainingWeightSum -= childWeight;
                    int childHeight = lp.height == 0 ? share : child.getMeasuredHeight() + share;
                    int childHeightMeasureSpec = MeasureSpec.makeMeasureSpec(Math.max(0, childHeight), MeasureSpec.Mode.EXACTLY);
                    int childWidthMeasureSpec = LinearLayout.getChildMeasureSpec(widthMeasureSpec, lp.leftMargin + lp.rightMargin, lp.width);
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                }
                int margin = lp.leftMargin + lp.rightMargin;
                int measuredWidth = child.getMeasuredWidth() + margin;
                maxWidth = Math.max(maxWidth, measuredWidth);
                boolean matchWidthLocally = widthMode.isVariable() && lp.width == -1;
                alternativeMaxWidth = Math.max(alternativeMaxWidth, matchWidthLocally ? margin : measuredWidth);
                allFillParent = allFillParent && lp.width == -1;
                this.totalLength = Math.max(this.totalLength, this.totalLength + child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            }
        } else {
            alternativeMaxWidth = Math.max(alternativeMaxWidth, weightedMaxWidth);
        }
        if (!allFillParent && widthMode.isVariable()) {
            maxWidth = alternativeMaxWidth;
        }
        maxWidth = Math.max(maxWidth, this.getMinWidth());
        this.setMeasuredDimension(LinearLayout.resolveSize(maxWidth, widthMeasureSpec), heightSize);
        if (matchWidth) {
            int uniformMeasureSpec = MeasureSpec.makeMeasureSpec(this.getMeasuredWidth(), MeasureSpec.Mode.EXACTLY);
            for (i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (child.getVisibility() == 2) continue;
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp.width != -1) continue;
                int lpHeight = lp.height;
                lp.height = child.getMeasuredHeight();
                this.measureChildWithMargins(child, uniformMeasureSpec, 0, heightMeasureSpec, 0);
                lp.height = lpHeight;
            }
        }
    }

    private void measureHorizontal(int widthMeasureSpec, int heightMeasureSpec) {
        int i;
        this.totalLength = 0;
        int maxHeight = 0;
        int alternativeMaxHeight = 0;
        int weightedMaxHeight = 0;
        boolean allFillParent = true;
        float totalWeight = 0.0f;
        boolean began = false;
        int count = this.getChildCount();
        MeasureSpec.Mode widthMode = MeasureSpec.getMode(widthMeasureSpec);
        MeasureSpec.Mode heightMode = MeasureSpec.getMode(heightMeasureSpec);
        boolean matchHeight = false;
        boolean skippedMeasure = false;
        if (this.maxAscent == null || this.maxDescent == null) {
            this.maxAscent = new int[4];
            this.maxDescent = new int[4];
        }
        int[] maxAscent = this.maxAscent;
        int[] maxDescent = this.maxDescent;
        maxAscent[3] = -1;
        maxAscent[2] = -1;
        maxAscent[1] = -1;
        maxAscent[0] = -1;
        maxDescent[3] = -1;
        maxDescent[2] = -1;
        maxDescent[1] = -1;
        maxDescent[0] = -1;
        int consumedExcessSpace = 0;
        int nonSkippedChildCount = 0;
        for (int i2 = 0; i2 < count; ++i2) {
            boolean useExcessSpace;
            View child = this.getChildAt(i2);
            if (child.getVisibility() == 2) continue;
            ++nonSkippedChildCount;
            if (!began) {
                if ((this.showDividers & 1) != 0) {
                    this.totalLength += this.dividerWidth;
                }
                began = true;
            } else if ((this.showDividers & 2) != 0) {
                this.totalLength += this.dividerWidth;
            }
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            totalWeight += lp.weight;
            boolean bl = useExcessSpace = lp.width == 0 && lp.weight > 0.0f;
            if (widthMode.isExactly() && useExcessSpace) {
                this.totalLength = Math.max(this.totalLength, this.totalLength + lp.leftMargin + lp.rightMargin);
                skippedMeasure = true;
            } else {
                if (useExcessSpace) {
                    lp.width = -2;
                }
                int usedWidth = totalWeight == 0.0f ? this.totalLength : 0;
                this.measureChildWithMargins(child, widthMeasureSpec, usedWidth, heightMeasureSpec, 0);
                int childWidth = child.getMeasuredWidth();
                if (useExcessSpace) {
                    lp.width = 0;
                    consumedExcessSpace += childWidth;
                }
                this.totalLength = widthMode.isExactly() ? (this.totalLength += childWidth + lp.leftMargin + lp.rightMargin) : Math.max(this.totalLength, this.totalLength + childWidth + lp.leftMargin + lp.rightMargin);
            }
            boolean matchHeightLocally = false;
            if (heightMode.isVariable() && lp.height == -1) {
                matchHeight = true;
                matchHeightLocally = true;
            }
            int margin = lp.topMargin + lp.bottomMargin;
            int childHeight = child.getMeasuredHeight() + margin;
            maxHeight = Math.max(maxHeight, childHeight);
            boolean bl2 = allFillParent = allFillParent && lp.height == -1;
            if (lp.weight > 0.0f) {
                weightedMaxHeight = Math.max(weightedMaxHeight, matchHeightLocally ? margin : childHeight);
                continue;
            }
            alternativeMaxHeight = Math.max(alternativeMaxHeight, matchHeightLocally ? margin : childHeight);
        }
        if (nonSkippedChildCount > 0 && (this.showDividers & 4) != 0) {
            this.totalLength += this.dividerWidth;
        }
        if (maxAscent[1] != -1 || maxAscent[0] != -1 || maxAscent[2] != -1 || maxAscent[3] != -1) {
            int ascent = Math.max(maxAscent[3], Math.max(maxAscent[0], Math.max(maxAscent[1], maxAscent[2])));
            int descent = Math.max(maxDescent[3], Math.max(maxDescent[0], Math.max(maxDescent[1], maxDescent[2])));
            maxHeight = Math.max(maxHeight, ascent + descent);
        }
        int widthSize = this.totalLength;
        widthSize = Math.max(widthSize, this.getMinWidth());
        widthSize = LinearLayout.resolveSize(widthSize, widthMeasureSpec);
        int remainingExcess = widthSize - this.totalLength + consumedExcessSpace;
        if (skippedMeasure || totalWeight > 0.0f) {
            float remainingWeightSum = this.weightSum > 0.0f ? this.weightSum : totalWeight;
            maxAscent[3] = -1;
            maxAscent[2] = -1;
            maxAscent[1] = -1;
            maxAscent[0] = -1;
            maxDescent[3] = -1;
            maxDescent[2] = -1;
            maxDescent[1] = -1;
            maxDescent[0] = -1;
            maxHeight = -1;
            this.totalLength = 0;
            for (i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (child.getVisibility() == 2) continue;
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                float childWeight = lp.weight;
                if (childWeight > 0.0f) {
                    int share = (int)(childWeight * (float)remainingExcess / remainingWeightSum);
                    remainingExcess -= share;
                    remainingWeightSum -= childWeight;
                    int childWidth = lp.width == 0 ? share : child.getMeasuredWidth() + share;
                    int childWidthMeasureSpec = MeasureSpec.makeMeasureSpec(Math.max(0, childWidth), MeasureSpec.Mode.EXACTLY);
                    int childHeightMeasureSpec = LinearLayout.getChildMeasureSpec(heightMeasureSpec, lp.topMargin + lp.bottomMargin, lp.height);
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                }
                this.totalLength = widthMode.isExactly() ? (this.totalLength += child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin) : Math.max(this.totalLength, this.totalLength + child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
                boolean matchHeightLocally = heightMode.isVariable() && lp.height == -1;
                int margin = lp.topMargin + lp.bottomMargin;
                int childHeight = child.getMeasuredHeight() + margin;
                maxHeight = Math.max(maxHeight, childHeight);
                alternativeMaxHeight = Math.max(alternativeMaxHeight, matchHeightLocally ? margin : childHeight);
                allFillParent = allFillParent && lp.height == -1;
            }
            if (maxAscent[1] != -1 || maxAscent[0] != -1 || maxAscent[2] != -1 || maxAscent[3] != -1) {
                int ascent = Math.max(maxAscent[3], Math.max(maxAscent[0], Math.max(maxAscent[1], maxAscent[2])));
                int descent = Math.max(maxDescent[3], Math.max(maxDescent[0], Math.max(maxDescent[1], maxDescent[2])));
                maxHeight = Math.max(maxHeight, ascent + descent);
            }
        } else {
            alternativeMaxHeight = Math.max(alternativeMaxHeight, weightedMaxHeight);
        }
        if (!allFillParent && heightMode.isVariable()) {
            maxHeight = alternativeMaxHeight;
        }
        maxHeight = Math.max(maxHeight, this.getMinHeight());
        this.setMeasuredDimension(widthSize, LinearLayout.resolveSize(maxHeight, heightMeasureSpec));
        if (matchHeight) {
            int uniformMeasureSpec = MeasureSpec.makeMeasureSpec(this.getMeasuredHeight(), MeasureSpec.Mode.EXACTLY);
            for (i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (child.getVisibility() == 2) continue;
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp.height != -1) continue;
                int lpWidth = lp.width;
                lp.width = child.getMeasuredWidth();
                this.measureChildWithMargins(child, widthMeasureSpec, 0, uniformMeasureSpec, 0);
                lp.width = lpWidth;
            }
        }
    }

    @Deprecated
    private boolean hasDividerBeforeChildAt(int childIndex) {
        if (childIndex == this.getChildCount()) {
            return (this.showDividers & 4) != 0;
        }
        boolean allViewsAreGoneBefore = this.allViewsAreGoneBefore(childIndex);
        if (allViewsAreGoneBefore) {
            return (this.showDividers & 1) != 0;
        }
        return (this.showDividers & 2) != 0;
    }

    @Deprecated
    private boolean allViewsAreGoneBefore(int childIndex) {
        for (int i = childIndex - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 2) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void onLayout(boolean changed) {
        if (this.orientation == Orientation.VERTICAL) {
            this.layoutVertical();
        } else {
            this.layoutHorizontal();
        }
    }

    private void layoutVertical() {
        int childTop;
        int count = this.getChildCount();
        int parentLeft = 0;
        int parentRight = this.getWidth();
        int parentTop = 0;
        int parentBottom = this.getHeight();
        int parentWidth = this.getWidth();
        int parentHeight = this.getHeight();
        int parentHorizontalGravity = this.gravity & 7;
        switch (this.gravity & 0x70) {
            case 80: {
                childTop = parentTop + parentHeight - this.totalLength;
                break;
            }
            case 16: {
                childTop = parentTop + (parentHeight - this.totalLength) / 2;
                break;
            }
            default: {
                childTop = parentTop;
            }
        }
        boolean began = false;
        for (int i = 0; i < count; ++i) {
            int childLeft;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 2) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int gravity = lp.gravity;
            if (gravity < 0) {
                gravity = parentHorizontalGravity;
            }
            int horizontalGravity = gravity & 7;
            switch (horizontalGravity) {
                case 1: {
                    childLeft = parentLeft + (parentWidth - width) / 2 + lp.leftMargin - lp.rightMargin;
                    break;
                }
                case 5: {
                    childLeft = parentRight + parentWidth - width - lp.rightMargin;
                    break;
                }
                default: {
                    childLeft = parentLeft + lp.leftMargin;
                }
            }
            if (!began) {
                if ((this.showDividers & 1) != 0) {
                    childTop += this.dividerHeight;
                }
                began = true;
            } else if ((this.showDividers & 2) != 0) {
                childTop += this.dividerHeight;
            }
            child.layout(childLeft, childTop += lp.topMargin, childLeft + width, childTop + height);
            childTop += height + lp.bottomMargin;
        }
    }

    private void layoutHorizontal() {
        int childLeft;
        int count = this.getChildCount();
        int parentLeft = this.getLeft();
        int parentRight = this.getRight();
        int parentTop = this.getTop();
        int parentBottom = this.getBottom();
        int parentWidth = this.getWidth();
        int parentHeight = this.getHeight();
        int parentVerticalGravity = this.gravity & 0x70;
        switch (this.gravity & 7) {
            case 5: {
                childLeft = parentLeft + parentWidth - this.totalLength;
                break;
            }
            case 1: {
                childLeft = parentLeft + (parentWidth - this.totalLength) / 2;
                break;
            }
            default: {
                childLeft = parentLeft;
            }
        }
        boolean began = false;
        for (int i = 0; i < count; ++i) {
            int childTop;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 2) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int gravity = lp.gravity;
            if (gravity < 0) {
                gravity = parentVerticalGravity;
            }
            int verticalGravity = gravity & 0x70;
            switch (verticalGravity) {
                case 16: {
                    childTop = parentTop + (parentHeight - height) / 2 + lp.topMargin - lp.bottomMargin;
                    break;
                }
                case 80: {
                    childTop = parentTop + parentHeight - height - lp.bottomMargin;
                    break;
                }
                default: {
                    childTop = parentTop + lp.topMargin;
                }
            }
            if (!began) {
                if ((this.showDividers & 1) != 0) {
                    childLeft += this.dividerWidth;
                }
                began = true;
            } else if ((this.showDividers & 2) != 0) {
                childLeft += this.dividerWidth;
            }
            child.layout(childLeft += lp.leftMargin, childTop, childLeft + width, childTop + height);
            childLeft += width + lp.rightMargin;
        }
    }

    public void setOrientation(Orientation orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.requestLayout();
        }
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setGravity(int gravity) {
        if (this.gravity != gravity) {
            if ((gravity & 7) == 0) {
                gravity |= 3;
            }
            if ((gravity & 0x70) == 0) {
                gravity |= 0x30;
            }
            this.gravity = gravity;
            this.requestLayout();
        }
    }

    public void setHorizontalGravity(int horizontalGravity) {
        if ((this.gravity & 7) != (horizontalGravity &= 7)) {
            this.gravity = this.gravity & 0xFFFFFFF8 | horizontalGravity;
            this.requestLayout();
        }
    }

    public void setVerticalGravity(int verticalGravity) {
        if ((this.gravity & 0x70) != (verticalGravity &= 0x70)) {
            this.gravity = this.gravity & 0xFFFFFF8F | verticalGravity;
            this.requestLayout();
        }
    }

    public int getGravity() {
        return this.gravity;
    }

    @Override
    @Nonnull
    protected ViewGroup.LayoutParams convertLayoutParams(@Nonnull ViewGroup.LayoutParams params) {
        if (params instanceof LayoutParams) {
            return params;
        }
        if (params instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)params);
        }
        return new LayoutParams(params);
    }

    @Override
    @Nonnull
    protected ViewGroup.LayoutParams createDefaultLayoutParams() {
        if (this.orientation == Orientation.HORIZONTAL) {
            return new LayoutParams(-2, -2);
        }
        return new LayoutParams(-1, -2);
    }

    @Override
    protected boolean checkLayoutParams(@Nullable ViewGroup.LayoutParams params) {
        return params instanceof LayoutParams;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public float weight;
        public int gravity = -1;

        public LayoutParams(int width, int height) {
            super(width, height);
            this.weight = 0.0f;
        }

        public LayoutParams(int width, int height, float weight) {
            super(width, height);
            this.weight = weight;
        }

        public LayoutParams(@Nonnull ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(@Nonnull ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(LayoutParams source) {
            super(source);
            this.weight = source.weight;
            this.gravity = source.gravity;
        }

        @Override
        @Nonnull
        public LayoutParams copy() {
            return new LayoutParams(this);
        }
    }
}

